if (name_input_active) {
    // Draw a semi-transparent overlay
    draw_set_color(c_black);
    draw_set_alpha(0.5);
    draw_rectangle(0, 0, display_get_width(), display_get_height(), false);
    draw_set_alpha(1);

    // Draw the input box
    var box_width = 300;
    var box_height = 100;
    var box_x = display_get_width() / 2 - box_width / 2;
    var box_y = display_get_height() / 2 - box_height / 2;
    draw_set_color(c_white);
    draw_rectangle(box_x, box_y, box_x + box_width, box_y + box_height, false);

    // Draw instructions and the input
    draw_set_halign(fa_center);
    draw_text(box_x + box_width / 2, box_y + 20, "Enter your name:");
    draw_text(box_x + box_width / 2, box_y + box_height / 2, global.player_name);
} else {
    // Calculate menu size before rendering
    calculate_menu_size();

    // Draw the menu background and options
    draw_set_font(global.font_main);
    x = camera_get_view_x(view_camera[0]) + camera_get_view_width(view_camera[0]) / 2 - width / 2;
    y = camera_get_view_y(view_camera[0]) + camera_get_view_height(view_camera[0]) / 2 - height / 2;

    draw_sprite_ext(sprite_index, image_index, x, y, width / sprite_width, height / sprite_height, 0, c_white, 1);
    draw_set_valign(fa_top);
    draw_set_halign(fa_left);

    for (var i = 0; i < array_length(option[menu_level]); i++) {
        var _c = (pos == i) ? c_yellow : c_white;
        var display_text = option[menu_level][i];
        if (menu_level == 2 && i == 1) {
            display_text = "Window mode: " + (global.fullscreen_enabled ? "Fullscreen" : "Windowed");
        }
        draw_text_color(x + op_border, y + op_border + op_space * i, display_text, _c, _c, _c, _c, 1);
    }
}
